import React from 'react';

interface SleekCafeBarThemeProps {
  mode: 'light' | 'dusky';
}

const SleekCafeBarTheme: React.FC<SleekCafeBarThemeProps> = ({ mode }) => {
  const styles = {
    light: {
      backgroundColor: '#f5f5dc',
      color: '#333333',
      accentColor: '#8b4513',
      secondaryColor: '#fff8dc',
      borderColor: '#deb887',
      backgroundImage: 'url("/public/images/royalty-free/modern cozy jazz cafe.jpg")',
    },
    dusky: {
      backgroundColor: '#2c1810',
      color: '#ffffff',
      accentColor: '#d2691e',
      secondaryColor: '#3c2415',
      borderColor: '#8b4513',
      backgroundImage: 'url("/public/images/royalty-free/cowboy cafe.jpg")',
    },
  };

  return (
    <div style={styles[mode]}>
      {/* Rest of the component content */}
    </div>
  );
};

export default SleekCafeBarTheme; 